<?php

class Ultimate_ai_Translation_Manager
{
  public function __construct()
  {
    add_action('wp_ajax_ultimate_ai_save_translated_string', [$this, 'save_translated_string']);
    add_action('wp_ajax_ultimate_ai_get_translated_string', [$this, 'get_translated_languages']);
    add_action('wp_ajax_ultimate_ai_save_default_language', [$this, 'save_default_language']);
    add_action('wp_ajax_ultimate_ai_delete_language', [$this, 'delete_language']);
  }

  private $translation_key = 'ultimate_ai_translation_manager';
  private $default_language_key = 'ultimate_ai_translation_default';
  private $default_language = 'english';

  private $default_string = [
    'common_text' => [
      'name' => 'Name',
      'view_all' => 'View all',
      'recent_history' => 'Recent History',
      'images' => 'Images',
      'blog_wizard' => 'Blog Wizard',
      'favorite' => 'Favorites',
      'unfavorite' => 'Unfavorite',
      'unlimited' => 'UNLIMITED',
      'rename' => 'Rename',
      'title' => 'Title',
      'tools_name' => 'Tools name',
      'words_generated' => 'Words Generated',
      'last_edited' => 'Last Edited',
      'deleted' => 'Delete',
      'confirm' => 'Confirm',
      'next' => 'Next',
      'prev' => 'Prev',
      'cancel' => 'Cancel',
      'history' => 'History',
      'result' => 'Result',
      'pro' => 'Pro',
      'free' => 'Free',
      'save' => 'Save',
      'back' => 'Back',
      'continue_btn' => 'Continue',
      'edit' => 'Edit',
      'add_new' => 'Add New',
      'words' => 'Words',
      'create_date' => 'Date created',
      'last_modify' => 'Last modified',
      'alphabetical' => 'Alphabetical',
      'languages' => 'Languages',
      'languages_tooltip' => 'Select your language',
      'open_ai' => 'Open AI',
      'elevenlabs' => 'ElevenLabs',
      'chat_assistant' => 'Chat assistant',
      'wordpress' => 'Wordpress',
      'regenerate' => 'Regenerate',
      'show_more' => ' Show more',
      'show_less' => ' Show less',
      'year' => 'Year',
      'month' => 'Month',
      'week' => 'Week',
      'order_id' => 'Order ID',
      'date' => 'Date',
      'customer' => 'Customer',
      'customer_id' => 'Customer ID',
      'payment_method' => 'Payment Method',
      'amount' => 'Amount',
      'status' => 'Status',
      'active' => 'Active',
      'banned' => 'Banned',
      'hold' => 'Hold',
      'paid' => 'Paid',
      'pending' => 'Pending',
      'expired' => 'Expired',
      'user_name' => 'Username',
      'email' => 'Email',
      'confirmed' => 'confirm',
      'users' => 'Users',
      'tts' => 'TTS',
      'role' => 'Role',
      'email_verify' => 'Email Verification',
      'created_at' => 'Created At',
      'create' => 'Create',
      'update' => 'Update',
      'phone_no' => 'Phone',
      'country_name' => 'Phone',
      'expire' => 'Expire',
      'prompt' => 'Prompt',
      'type' => 'Type',
      'action' => 'Action',
      'discount' => 'Discount',
      'require_field' => 'This field is required',
      'save_changes' => ' Save changes',
      'update_settings' => 'Update settings',
      'plan' => 'Plan',
      'images_credit' => 'Images Credits:',
      'words_credit' => 'Words Credits:',
      'tts_credit' => 'Text to speech Credits:',
    ],
    'user_dashboard' => [
      'words_generated' => 'Words Generated',
      'documents_generated' => 'Documents Generated',
      'time_save' => 'Time Saved',
      'tool_used' => 'Tool Used',
      'most_popular_tool' => 'Most Popular Tool',
      'most_popular_tool_sub_title' => 'These are the most popular tools and a good place to start. Give them a try!',
      'new_offer' => 'Check out these new tools UltimateAI has to offer! 🎉',
    ],
    'ai_writing_tools' => [
      'title' => 'AI Writing Tools',
      'search_template_placeholder' => 'Search templates',
    ],
    'image_generation' => [
      'title' => 'Turn text into an image with the <span>AI Image Generator</span>',
      'sub_title' => 'Input text prompts and use Dall-E or Diffusion to generate images and artsusing Simplified’s AI Image Generator.',
      'try_an_example' => 'Try an example',
      'aspect_ratio_1' => 'Square (1:1)',
      'aspect_ratio_2' => 'Landscape (4:3)',
      'aspect_ratio_3' => 'Portrait (3:4)',
      'aspect_ratio_4' => 'Widescreen (16:9)',
      'size_1' => '256 x 256',
      'size_2' => '512 x 512',
      'size_3' => '1024 x 1024',
      'size_4' => '1792x1024',
      'performance_1' => 'Speed',
      'performance_2' => 'Balanced',
      'performance_3' => 'Quality',
      'sampler_title' => 'Sampler',
      'sampler_subtitle' => 'Defines the sampling method used to generate the image.',
      'generation_parameters' => 'Generation Parameters',
      'similarity_to_the_image' => 'Similarity to the image',
      'seed' => 'Seed',
      'seed_subtitle' => 'Use a new random seed for each creation',
      'upscale_enhance' => 'Upscale & Enhance',
      'upscale_subtitle' => 'Upscale (Output: 1280 x 1280)',
      'private_generation' => 'Private Generation',
      'private_generation_subtitle' => 'After enabling this feature, every image you generate will not be automatically shared to the community feed.',
      'negative_prompt' => 'Negative Prompt',
      'negative_prompt_title' => 'Describe what you don’t want in your images.',
      'unleash_your_creativity' => 'Unleash your creativity with our AI Image Generator! As a free user, your crafted AI images will be automatically shared, contributing to the vibrant community gallery.',
      'prompt' => 'Prompt',
      'generate' => 'Generate',
      'text_to_image' => 'Text to Image',
      'image_remix' => 'Image Remix',
      'recent_tab' => 'Recent',
      'favorite_tab' => "My Favorite's",
      'number_of_image' => 'Number of images',
      'high' => 'High',
      'medium' => 'Medium',
      'low' => 'Low',
    ],
    'my_content' => [
      'my_content' => 'My Content',
      'document_editor' => 'Document Editor',
      'blog_wizard' => 'Blog Wizard',
      'ai_vision' => 'AI Vision',
      'image_generation' => 'Image Generation',
      'recent_history' => 'Recent History',
      'images_tab' => 'Images',
      'blog_wizard_tab' => 'Blog Wizard',
      'new_document' => 'New document',
      'words' => 'Words',
      'weeks' => 'Weeks ago',
      'months' => 'Months ago',
      'year' => 'Year ago',
      'grid' => 'GRID',
      'list' => 'LIST',
    ],
    'chatbot' => [
      'title' => 'How can I help you today?',
      'suggestions_one_title' => 'Recommend activities',
      'suggestions_one_subtitle' => 'For a team-building day with remote employees',
      'suggestions_two_title' => 'Tell me a fun fact',
      'suggestions_two_subtitle' => 'About the Roman Empire',
      'suggestions_three_title' => 'Write a short story',
      'suggestions_three_subtitle' => 'About a lost key that holds a mysterious secret',
      'suggestions_four_title' => 'Plan a trip',
      'suggestions_four_subtitle' => 'To see the northern lights in Norway',
      'chat_persona' => 'Chat Persona',
      'chat_persona_subtitle' => 'Choose from different personas to enhance your chat experience.',
      'create_assistant' => 'Create assistant',
      'general_ai' => 'General AI',
      'general_ai_subtitle' => 'A general AI that can talk about anything.',
      'web_search' => 'Web Search',
      'web_search_dec' => 'Chose an online source to browser the internet. Adding URLS works with publicly accessible pages.',
      'web_search_dec_btn' => 'Learn more',
      'chat_history' => 'Chat history',
      'new_chat' => ' New Chat',
    ],
    'code_generator' => [
      'title' => 'Code Generator',
      'subtitle' => 'Generate programming code from a text input.',
      'body_text' => 'Pick a template or Generate Code with AI',
      'describe' => 'Describe what kind of code you need',
      'programming_languages' => 'Programming Languages',
      'programming_languages_tooltip' => 'Select your language/library',
    ],
    'blog_wizard' => [
      'seo_key' => 'Code Generator',
      'seo_keyword_subtitle' => 'Define keywords that you would like to appear in the blog. We’ll incorporate them where appropriate.',
      'advanced_customizations' => 'Advanced Customizations',
      'blog_title' => 'Blog Title',
      'blog_subtitle' => 'Choose one of our suggested titles or write your own.',
      'outline' => 'Outline',
      'outline_subtitle' => 'Choose one of our suggested titles or write your own.',
      'step_1_title' => 'Start',
      'step_2_title' => 'Blog Title',
      'step_3_title' => 'Outlines',
      'step_4_title' => 'Generate',
      'generate_full' => 'Generate Full Article',
      'audience_1' => 'Everyone',
      'audience_2' => 'Shoppers',
      'audience_3' => 'College Students',
      'audience_4' => 'New Parents',
      'audience_5' => 'Fitness Enthusiasts',
      'audience_6' => 'Small Business Owners',
      'audience_7' => 'Seniors',
      'blog_post_about' => 'What is your blog post about?',
      'blog_post_about_placeholder' => 'A blog post on how to start an online store',
      'tone_of_voice' => 'Tone of voice',
      'target_audience' => 'Targated audience',
      'target_audience_subtitle' => 'This option enables you to choose a specific audience to target so we tailor your content around their unique motivations and pain points.',
      'point_of_view' => 'Point of view',
      'point_of_view_tooltip' => 'Determine the perspective from which your article is written. Third-person can offer an objective tone, while first-person creates a personal touch.',
      'point_of_view_1' => 'First Person Singular (I, me, my, mine)',
      'point_of_view_2' => 'First Person Plural (we, us, our, ours)',
      'point_of_view_3' => 'Second Person (you, your, yours)',
      'point_of_view_4' => 'Third Person (he, she, it, they)',
      'length' => 'Length',
      'length_1' => 'Small(~1000 words)',
      'length_2' => 'Semi Medium(~1500 words)',
      'length_3' => 'Medium(~2000 words)',
      'length_4' => 'Large(~2500 words)',
      'primary_key_title' => 'Primary keywords',
      'primary_key_placeholder' => 'Press enter to add primary keywords.',
      'secondary_key_title' => 'Secondary keywords',
      'secondary_key_placeholder' => 'Press enter to add secondary keywords.',
      'describe_your_brand' => 'Describe your brand ',
      'describe_your_brand_placeholder' => 'Tell us about your brand, and we will promote it in the generated article',
      'describe_your_product' => 'Describe your product',
      'describe_your_product_placeholder' => 'A blog post on how to start an online store',
      'add_custom_title' => 'Add Custom Title',
      'add_custom_title_placeholder' => 'Enter your title here',
      'regenerate' => 'Regenerate',
      'add_section' => 'Add Section',
      'we_working' => 'We’re working on it. This may take a few minutes.',
      'perfecting_blog_post' => '   Perfecting the details of your blog post',
    ],
    'text_to_speech' => [
      'title' => 'Text To Speech & Voice Cloning',
      'subtitle' => 'AI Voice Generator: Realistic Text to Speech & Voice Cloning',
      'voice_settings' => 'Voice settings',
      'advance_voice_setting' => 'Advance voice setting',
      'body_text' => 'Pick a ai model and Generate voice',
      'enter_text_here' => 'Enter our text here',
      'enter_text_placeholder' => 'Please, be specific as possible',
      'stability' => 'Stability',
      'clarity_similarity' => 'Clarity + Similarity',
      'unstable' => 'unstable',
      'speaker_boost' => 'Speaker Boost',
      'low' => 'Low',
      'high' => 'High',
    ],
    'ai_vision' => [
      'title' => 'How can I help you today?',
      'massage_1' => 'How many calories in this?',
      'massage_2' => 'What type of house is this?',
      'massage_3' => 'Write an image title and text best suited for SEO',
      'massage_4' => 'What’s happening in this picture?',
      'new_chat' => ' New Chat',
      'chat_history' => 'Chat history',
      'delete_message_title' => 'Are you sure you want to delete this chat?',
      'delete_message_dec' => 'Deleting this chat will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
    ],
    'editor' => [
      'ask_ai' => 'Ask AI',
      'improve' => 'Improve',
    ],
    'admin_dashboard' => [
      'total_earning' => 'Total Earnings',
      'total_order' => 'Total Orders',
      'week_stats' => "This Week's Stats",
      'all_time_report' => 'All-Time Report',
      'words_generate' => 'Words Generated',
      'images_generate' => 'Images Generated',
      'total_users' => 'Total Users',
      'active_users' => 'Active Users',
      'revenue_title' => 'Revenue',
      'revenue_subtitle' => 'Total revenue',
      'subscription_sales' => 'Subscription sales',
      'token_sales' => 'Token sales',
      'weekly_update' => 'Weekly Update',
      'words' => 'Words',
      'images' => 'Images',
      'recent_order' => 'Recent Order',
      'from_last_month' => 'From last month',
      'from_last_week' => 'From last week',
    ],
    'user_management' => [
      'title' => 'Manage Users',
      'add_new_user' => 'Add New User',
      'password_reset_info' => 'Password reset link will be sent to the user via email',
      'contact_info' => 'Contact information',
      'payment_history' => 'Payment History',
      'words_generate' => 'Words Generated',
      'images_generate' => 'Images Generated',
      'add_user' => 'Add User',
      'modify_limits' => 'Modify Limits',
      'set_user_usage_data' => 'Set User usage data',
      'word_token' => 'Words token amount',
      'image_token' => 'Image token amount',
      'tts_token' => 'TTS token amount',
      'reset_previous_token' => 'Reset previous tokens',
      'password_reset' => 'Reset previous tokens',
      'delete_user' => 'Delete user',
      'delete_user_confirm_title' => 'Are you sure you want to delete this User?',
      'delete_user_confirm_dec' => 'Deleting this user will permanently remove all associated data, meta, subscription, images, and settings. This action cannot be undone.',
      'modify_usage' => 'Modify Usage',
      'verify_email' => 'Verify Email',
      'address' => 'Address',
      'list_of_order' => '# List of order',
    ],
    'manage_order' => [
      'title' => 'Manage Orders',
      'add_subscriber' => 'Add Subscriber',
      'general_details' => 'General Details',
      'subscription_history' => "Subscription's History",
      'delete_order_confirm' => 'Are you sure you want to delete this orders?',
      'delete_order_confirm_subtitle' => 'Deleting this orders will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
      'add_user' => 'Add User',
      'selected' => 'Selected',
      'choose_interval' => 'Choose interval',
      'subscription_mode' => 'Subscription Mode',
      'subscription_mode_tooltip' => 'Test',
      'user_email' => 'User Email',
      'user_email_placeholder' => 'Email address',
      'search_by_subs_id_placeholder' => 'Search by subscription id',
      'choose_package' => 'Choose Package',
      'choose_package_tooltip' => 'Test',
      'subscription_pack' => 'Subscription',
      'token_pack' => 'Token',
      'monthly' => 'Monthly',
      'yearly' => 'Yearly',
      'pay_subscription' => ' Pay Subscription for',
      'pay_upfront' => 'Pay upfront for',
      'expired_date' => 'Expired Date',
      'started_date' => 'Started Date',
      'list_of_order' => '# List of order',
    ],
    'template' => [
      'title' => 'Prompts and Formulas',
      'create_new' => 'Create New',
      'new_template' => 'Create New Template',
      'edit_template' => 'Edit Template',
      'additional_info' => "Additional information's",
      'additional_info_subtitle' => 'Fill in the input to kick off your workflow.',
      'tools_customization' => 'Tools Customization',
      'tools_customization_subtitle' => 'Your output will appear below.',
      'prompt' => 'Prompt',
      'prompt_subtitle' => 'Construct your magical prompt for ai. Use fields id as a variable name to make dynamic prompt.',
      'available_variable_to_use' => 'Available variable to use:',
      'success_title' => "That's all!",
      'success_subtitle' => 'You have successfully created your template.',
      'edit_tools' => 'Edit Tools',
      'delete_confirm_title' => 'Are you sure you want to delete this Template?',
      'delete_confirm_dec' => 'Deleting this template will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
      'language_field' => 'Language',
      'language_field_placeholder' => 'Select your language',
      'tone_of_voice_field' => 'Tone of Voice',
      'tone_of_voice_field_placeholder' => 'Result tone of voice',
      'number_of_result_field' => 'Number of result',
      'number_of_result_field_placeholder' => '1',
      'result_format_field' => 'Result format',
      'result_format_field_placeholder' => 'Paragraph',
      'template_name' => 'Template name',
      'template_name_placeholder' => 'ex: SEO Content Brief',
      'template_unique_key' => 'Template unique key',
      'template_unique_key_placeholder' => 'ex: seo_content_brief',
      'template_description' => 'Description',
      'template_description_placeholder' => 'Make a description to make it more clear to the audience.',
      'icon_upload' => 'Upload icon',
      'icon_size' => 'Upload svg or png 24x24',
      'feature_toolbar' => 'Featured toolbar',
      'feature_mode' => ' Pick Your Featured Mood',
      'result_format_field_label_1' => 'Paragraph',
      'result_format_field_label_2' => 'List',
      'add_option_btn' => 'Add Option',
      'required' => 'Required',
      'template_prompt' => 'Template Prompt:',
      'template_prompt_placeholder' => 'ex: You are a bird specialist. You speak in [[language]] language. Bird name is [[name]]. Give me [[name]] bird 5 information.',
    ],
    'categories' => [
      'title' => 'Create & Manage Categories',
      'button_text' => 'Create New',
      'new_category' => 'Create New Categories',
      'edit_category' => 'Edit Categories',
      'form_title' => "Additional information's",
      'form_subtitle' => 'Fill in the input to kick off your workflow.',
      'select_tools' => 'Select Tools',
      'select_tools_subtitle' => 'Type a name for your plan. (Starter, Growth, Ultimate etc.)',
      'description' => 'Description',
      'tools' => 'Tools',
      'delete_confirm' => 'Are you sure you want to delete this Category?',
      'delete_confirm_dec' => 'Deleting this Category will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
      'category_name' => 'Categories Name',
      'category_name_placeholder' => 'unique category name',

      'category_description_placeholder' => 'Make a description to make it more clear to the audience.',
    ],
    'chat_assistant' => [
      'title' => 'Chat Assistant',
      'button_text' => 'Create New',
      'new_persona' => 'Add New Persona',
      'edit_persona' => 'Edit Persona',
      'form_title' => "Additional information's",
      'form_subtitle' => 'Fill in the input to kick off your workflow.',
      'select_tools' => 'Select Tools',
      'select_tools_subtitle' => 'Type a name for your plan. (Starter, Growth, Ultimate etc.)',
      'template_name' => 'Template Name',
      'description' => 'Description',
      'description_optional' => 'Description (optional)',
      'description_optional_placeholder' => 'eg. Helpful assistant for my digital marketing needs.',
      'search_template' => 'Search template',
      'instruction_for_persona' => 'Instruction for AI Persona (Prompt)',
      'instruction_for_persona_placeholder' => 'eg. Act as a digital marketing specialist. I will give you my marketing needs and you will help me with them.',
      'delete_confirm' => 'Are you sure you want to delete this Template?',
      'delete_confirm_dec' => 'Deleting this template will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
      'persona_image' => 'Persona image',
      'persona_image_size' => 'Avatar max size will be 200kb',
    ],
    'manage_subscription' => [
      'title' => 'Manage Subscription & Token Packs',
      'button_text' => 'Create plan',
      'plan_name' => 'Plan Name',
      'words_limit' => 'Words Limit',
      'images_limit' => 'Images Limit',
      'price' => 'Price',
      'tools' => 'Tools',
      'modify' => 'Modify',
      'delete_confirm' => 'Are you sure you want to delete this Template?',
      'delete_confirm_dec' => 'Deleting this template will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
    ],
    'create_subscription' => [
      'create_subscription' => 'Create Subscriptions',
      'edit_subscription' => 'Edit Subscriptions',
      'form_title' => 'Basic configuration',
      'form_subtitle' => 'Type a name for your plan. (Starter, Growth, Ultimate etc.)',
      'plan_name' => 'Plan name',
      'plan_name_placeholder' => 'eg. Starter plan',
      'choose_package' => 'Choose package ',
      'package_type' => 'Package type',
      'subscription_pack' => 'Subscription pack',
      'subscription_pack_subtitle' => 'In this type pack users will pay recurring bills monthly or yearly.',
      'token_pack' => 'Token pack',
      'token_pack_subtitle' => 'In this type pack users will pay one time bill.',
      'configure_plan' => 'Configure plan settings',
      'configure_plan_subtitle' => 'Fill your package and pricing details',
      'free_plan' => 'Free plan',
      'free_plan_subtitle' => 'No charge or fees will be deducted.',
      'paid_plan' => 'Paid plan',
      'paid_plan_subtitle' => 'Customers will be asked for payment to use features.',
      'package_details' => 'Package Details',
      'select_tools' => 'Select Tools',
      'select_tools_subtitle' => 'Choose tools those are fit in the package',
      'integration_support' => 'Integration support',
      'advance_tools' => 'Advanced Tools',
      'additional_info' => "Additional information's",
      'additional_info_subtitle' => 'Type a name for your plan. (Starter, Growth, Ultimate etc.)',
      'billing_period' => 'Billing period',
      'yearly' => 'Yearly',
      'monthly' => 'Monthly',
      'total_words' => 'Total words',
      'total_images' => 'Total images',
      'text_to_speech_characters' => 'Text to speech characters',
      'feature_mode' => 'Pick Your Featured Mood',
      'select_all_tools' => ' Select all tools',
      'at_least_select_one_tools' => 'Select at least one tools',
      'price_note' => 'Price note',
      'price_note_placeholder' => 'ex: 100000 words / 1 user',
      'highlight_text' => 'Highlight text',
      'highlight_text_placeholder' => 'i.e: Get the following benefits',
      'pricing_key_point' => 'Pricing key points',
      'pricing_key_point_placeholder' => 'Describe the features, separated by comma..',
    ],
    'pricing' => [
      'head_title_1' => 'Start writing ',
      'head_title_2' => '10x faster',
      'head_title_3' => ' with AI',
      'head_subtitle_1' => 'Write',
      'head_subtitle_2' => ' blog posts, web pages, ads and more,',
      'head_subtitle_3' => ' in a fraction of  the time and cost compared to traditional copywriting.',
      'subscription_pack' => 'Subscription Pack',
      'token_pack' => 'Token Pack',
      'faq_title' => 'Frequently Asked Questions',
      'pay_monthly' => 'Pay Monthly',
      'pay_yearly' => 'Pay Yearly',
      'save_up_to' => 'Save up to 20%',
      'most_popular' => 'Most Popular',
      'purchase_now' => 'Purchase now',
      'choose_a_way_to_pay' => 'Choose a way to pay',
      'current_plan' => 'Current Plan',
    ],
    'faq' => [
      'title' => 'Frequently Asked Questions',
      'create_faq' => 'Create FAQ',
      'edit_faq' => 'Edit FAQ',
      'create_new' => 'Create New',
      'answer' => 'Answer',
      'question' => 'Question',
      'delete_confirm' => 'Are you sure you want to delete this FAQ?',
      'delete_confirm_dec' => 'Deleting this FAQ will permanently remove all associated data, including test variations, results, and settings. This action cannot be undone.',
    ],
    'app_settings_tabs' => [
      'settings' => 'Settings',
      'app_settings' => 'App Settings',
      'menu_settings' => 'Menu Settings',
      'appearance' => 'Appearance',
      'api_key' => 'API Key',
      'integration' => 'Integration',
      'activation' => 'Activation',
      'translation' => 'Translation',
      'general_settings' => 'General Settings',
    ],
    'general_settings' => [
      'free_credit' => 'Free credit',
      'free_credit_subtitle' => 'When enabled, repeated requests with the same data will get a quick and free response from cached memory.',
      'word_credit' => 'Word credit',
      'image_credit' => 'Image credit',
      'tts_credit' => 'Text to speech credit',
      'unmetered_usage_title' => 'Unmetered usage',
      'unmetered_usage_subtitle' => 'When enabled, users will be able to use restriction less data.',
      'app_restrictions' => 'App restrictions',
      'app_restrictions_subtitle' => "When a logged-out user tries to access the dashboard will be redirected to this url. (don't use / at the end of the url).",
      'login_register' => 'Register/login page url',
      'login_register_placeholder' => 'https://domain.com/account',
      'email_verification' => 'Email Verification',
      'email_verification_subtitle' => 'When enabled, user will be asked to verify their email after they register. When they click on verification link from email, their account will be activated.',
      'app_access' => 'App access',
      'app_access_subtitle' => 'App access without login',
      'access_integration' => 'Access integration',
      'access_integration_subtitle' => 'Integration access for new user registration.',
      'customize_phrases' => 'Customize phrases',
      'customize_phrases_subtitle' => 'Your secret API keys are listed below. Please note that we do not display your secret API keys again after you generate them.',
      'welcome_message' => 'Welcome message',
      'welcome_message_placeholder' => "Let's bring your ideas to life!, welcome back!",
      'show_off_tools' => 'Show offer tools',
      'show_off_tools_subtitle' => 'Decide whether customers should see a home screen in your offer widget.',
    ],
    'app_settings' => [
      'free_usage' => 'Free usage upon registration',
      'chat_assistant' => 'Chat assistant',
      'wordpress' => 'Chat assistant',
      'free_usage_subtitle' => 'When enabled, repeated requests with the same data will get a quick and free response from cached memory.',
      'login_settings' => 'Login Settings',
      'login_settings_subtitle' => 'When enabled, repeated requests with the same data will get a quick and free response from cached memory.',
      'email_verification' => 'Email Verification',
      'email_verification_subtitle' => 'When enabled, user will be asked to verify their email after they register. When they click on verification link from email, their account will be activated.',
      'default_ai_model' => 'Default OpenAI model',
      'default_ai_model_subtitle' => 'Review your total usage across the platform since you registered.',
      'integration_access' => 'Integration access upon registration',
      'integration_access_subtitle' => 'Review your total usage across the platform since you registered.',
      'default_open_ai_settings' => 'Default OpenAI settings',
      'default_dall_e_settings' => 'Default DALL-E Settings',
      'default_stable_diffusion_settings' => 'Default Stable Diffusion Settings',

      'tone_of_voice' => 'Tone of voice',
      'tone_of_voice_tooltip' => 'Default tone of voice',
      'number_of_result' => 'Number of results',
      'number_of_result_tooltip' => 'Default number of results',
      'maximum_output_length' => 'Maximum output length',
      'maximum_output_length_tooltip' => 'Default output length',
      'default_language' => 'Default language  ',
      'default_language_tooltip' => 'Default language to use',
      'chatbot_model' => 'Chatbot model',
      'chatbot_model_tooltip' => 'Default chatbot model',
      'chatbot_persona_model' => 'Chatbot persona model',
      'chatbot_persona_model_tooltip' => 'Default persona model',
      'code_model' => 'Default code model',
      'code_model_tooltip' => 'Default code model',
      'number_of_code_result' => 'Number of code results',
      'number_of_code_tooltip' => 'Default number of result',
      'ai_image_model' => 'AI Image model',
      'ai_image_model_tooltip' => 'Default model',
      'maximum_image_size' => 'Maximum image size',
      'maximum_image_size_tooltip' => 'Default image size',
      'text_to_speech' => 'Text to speech(Characters)',
      'activate_unmatered' => 'Activate Unmetered Usage',
      'activate_unmatered_dec' => 'When enabled, users will be able to use restriction less data. For example when using a tool user will have data limit normally but this will be overpassed by this when its activated',
      'login_register_label' => 'Register/login page url',
      'login_register_label_placeholder' => 'https://domain.com/account',

      'model_settings' => 'Model settings',
      'model_settings_subtitle' => 'Review your total usage across the platform since you registered.',
      'tools_customization' => 'Tools customizations',
      'tools_customization_subtitle' => 'Review your total usage across the platform since you registered.',
      'image_customization' => 'Image customizations',
      'image_customization_subtitle' => 'Review your total usage across the platform since you registered.',
      'app_model' => 'App model',
      'image_model' => 'Image model',
      'code_model_label' => 'Code model',
      'chatbot_assistant_model' => 'Chatbot assistant model',
    ],
    'menu_settings' => [
      'add_custom_menu' => 'Add custom menu',
      'open_new_tab' => ' Open in new tab',
      'menu_title' => 'Title',
      'menu_title_placeholder' => 'Your title name',
      'upload_icon' => 'Upload icon',
      'upload_icon_size' => 'Upload svg or png 20x20',
      'menu_url' => 'URL',
      'menu_url_placeholder' => 'https://',
      'menu_type' => 'custom',
      'navigation_menu_settings' => 'Navigation menu settings',
      'navigation_menu_subtitle' => 'If this is enabled users cannot login unless they confirm their emails.',
      'quick_access_settings' => 'Quick access settings',
      'quick_access_settings_subtitle' => 'Set quick access menu on header',
      'home' => 'Home',
      'my_content' => 'My Content',
      'ai_writing_tools' => 'AI Writing Tools',
      'image_generator' => 'Image Generator',
      'chatbot' => 'Chatbot',
      'ai_vision' => 'AI Vision',
      'code_generator' => 'Code Generator',
      'blog_wizard' => 'Blog Wizard',
      'editor' => 'Ultimate Editor',
      'text_to_speech' => 'Text To Speech',
      'analytics' => 'Analytics',
      'user_management' => 'User Management',
      'orders' => 'Orders',
      'template' => 'Template',
      'templates' => 'Templates',
      'ai_templates' => 'Templates',
      'create_templates' => 'Create Templates',
      'categories' => 'Categories',
      'chat_assistant' => 'Chat assistant',
      'subscriptions' => 'Subscriptions',
      'manage_subscriptions' => 'Manage Subscriptions',
      'create_subscription' => 'Create Pack',
      'pricing' => 'Pricing',
      'faq' => 'Faq',
      'admin_settings' => 'App Settings',
      'admin_model' => 'Admin model',
      'user_model' => 'User model',
      'quick_access_menu' => 'Quick Access',
      'themes' => 'Themes',
    ],
    'header_top' => [
      'words_credit' => 'Words Credit',
      'unlimited' => 'Unlimited',
      'Upgrade' => 'Upgrade',
      'new_content' => 'New Content',
    ],
    'appearance' => [
      'appearance' => 'Appearance',
      'appearance_subtitle' => 'Customize theme appearance.',
      'brand_logo' => 'Brand color',
      'brand_logo_subtitle' => 'Select or customize your brand color.',
      'app_interface' => 'App Interface',
      'app_interface_subtitle' => 'Select or customize your app',
      'sidebar_features' => 'Sidebar features',
      'sidebar_features_subtitle' => 'What shows in the desktop sidebar.',
      'tables_view_title' => 'Tables view',
      'tables_view_subtitle' => 'How to tables displayed in the app.',
      'main_logo' => 'Main logo',
      'main_logo_dec' => 'Upload logo with clear corners',
      'secondary_logo' => 'Secondary logo',
      'custom_color' => 'Custom color',
      'welcome_message' => 'Set your welcome message',
      'welcome_message_placeholder' => "Let's bring your ideas to life!, welcome back!",
      'enable_campaign' => 'Enable campaign',
      'enable_campaign_dec' => "Get emails to find out what's going on when you're not online. You can turn these off.",
      'offer_and_promotion' => 'Offer and promotions',
      'offer_and_promotion_dec' => 'Promotions about software package prices and about the latest discounts.',
      'featured_campaign' => 'Featured campaign',
      'featured_campaign_option' => 'Campaign 5',
      'default_tables' => 'Default',
      'compact_tables' => 'Compact',
    ],
    'api_key' => [
      'api_settings' => 'API Settings',
      'api_settings_subtitle_1' => 'Your secret API keys are listed below. Please note that we do not display your secret API keys again after you generate them.',
      'api_settings_subtitle_2' => "Do not share your API key with others, or expose it in the browser or other client-side code. In order to protect the security of your account, OpenAI may also automatically disable any API key that we've found has leaked publicly.",
      'open_ai_api_key' => 'OpenAI API Key',
      'enable_tracking' => 'Enable tracking to see usage per API key on the',
      'link_text' => 'Usage page.',
      'cache_responses' => 'Cache responses',
      'cache_responses_subtitle' => 'When enabled, repeated requests with the same data will get a quick and free response from cached memory.',
      'tracking_switch' => 'Enable tracking',
      'tracking_switch_subtitle' => 'Enable tracking to see usage per API key.',
      'image_generation_api' => 'Image generator API Settings',
      'image_generation_api_subtitle' => 'Your secret API keys are listed below. Please note that we do not display your secret API keys again after you generate them.',
      'stable_diffusion' => 'Stable Diffusion',
      'social_login_api' => 'Social Login API Settings',
      'social_login_api_subtitle' => 'Your secret API keys are listed below. Please note that we do not display your secret API keys again after you generate them.',
      'facebook' => 'Facebook API',
      'facebook_subtitle' => 'The Login button is a simple way to trigger the Facebook Login process on your website or web app.',
      'google_api' => 'Google API',
      'google_api_subtitle' => 'The easiest way to add a Google Sign-In button to your site is to use an automatically rendered sign-in button.',
      'live' => 'Live',
      'open_ai_secret' => 'OpenAi API Secret',
      'open_ai_secret_placeholder' => 'Enter your api key',
      'secret_key' => 'SECRET KEY',
      'api_secret_key' => 'Api Secret / Secret Key',
      'enable_engine' => 'Enable Engine',
      'engine_id' => 'Engine id',
      'image_upscaler_engine' => 'Image upscaler engine',
      'upcoming' => 'Upcoming',
    ],
    'integration' => [
      'title' => 'All Integration',
      'configure' => 'Configure',
      'api_setting' => 'API Settings',
      'api_kei_label' => 'Api Key',
      'subtitle' => 'Connect and sync with essential tools and platforms.',
      'stipe_subtitle' => 'Create and manage subscriptions, payments, and recurring revenue with the Stripe APIs.',
      'paypal_subtitle' => 'The Payouts API enables you to send payouts programmatically to your recipients.',
      'elevenlabs_subtitle' => "Integrate effortlessly with ElevenLabs API. Elevate your projects, innovate seamlessly. Let's revolutionize together.",
    ],
    'activation' => [
      'be_aware' => 'Be Aware!! Before Update',
      'be_aware_subtitle_1' => "Please make that you have backup from your server's files and database before applying the update. Otherwies, we may lose your files if you have custom changes.",
      'be_aware_subtitle_2' => 'Make sure you have write permission on your files and folder. To check the files permission, click on File Permission Check',
      'be_aware_subtitle_3' => 'Make sure you have stable internet connection',
      'be_aware_subtitle_4' => 'Do not close the tab while the process is running.',
      'active_your_license' => 'Activate your license',
      'active_your_license_subtitle_1' => 'Thanks for purchashing UltimateAI!',
      'active_your_license_subtitle_2' => ' Please connect to',
      'active_your_license_subtitle_3' => 'Tophive',
      'active_your_license_subtitle_4' => 'to verify your purchase.',
      'register_license_key' => 'Register License Key *',
      'trouble_1' => 'Having trouble?',
      'trouble_2' => 'Check documentations',
      'plugin_update' => 'Plugin Updates',
      'installed_version' => 'Installed Version',
      'license_key' => 'License Key',
      'deactivate' => 'Deactivate',
      'activate' => 'Activate',
    ],
    'account_settings' => [
      'account_settings' => 'Account Settings',
      'usage' => 'Usage',
      'billing_and_plan' => 'Billing & Plan',
      'integration' => 'Integration',
      'preferences' => 'Preferences',
      'help_center' => 'Help Center',
      'logout' => 'Log Out',
      'personal_information' => 'Personal Information',
      'personal_information_dec' => 'Manage your personal information and settings.',
      'first_name' => 'First name',
      'first_name_placeholder' => 'Your first name',
      'last_name' => 'Last name',
      'last_name_placeholder' => 'Your last name',
      'email' => 'Email',
      'username' => 'Username',
      'username_placeholder' => 'Your username',
      'country' => 'Country',
      'phone' => 'Phone',
      'street_address' => 'Street address',
      'street_address_placeholder' => 'Your street address',
      'state_province' => 'State / Province',
      'state_province_placeholder' => 'Your state / province',
      'zip_postal_code' => 'Zip / Postal code',
      'zip_postal_code_placeholder' => 'Your zip / postal code',
      'change_password_title' => 'CHANGE YOUR PASSWORD',
      'change_password_warning' => 'Your password must be between 6 and 16 characters long
        and contain at least one letter and one number.',
      'current_password' => 'Current password',
      'forgot_password' => 'Forgot your password?',
      'new_password' => 'New password',
      'new_password_error' => 'Please enter your new password',
      'confirm_password' => 'Confirm password',
      'confirm_password_error' => 'Please input your new password again',
      'delete_account' => 'Delete account',
      'delete_account_title' => 'Are you sure you want to delete your account?',
      'delete_account_dec' => 'All of your data will be erased and will not be recoverable. This is an irreversible action and cannot be undone. We will keep some or all of your data if we suspect fraud or if the law requires it. Proceed carefully.',
      'delete_account_confirm' => 'Understood, I confirm my account deletion.',
      'delete_btn_text' => 'Delete my account',
      'upload_avatar' => 'Upload Avatar',
      'upload_avatar_type' => 'JPG, PNG, AVIF or GIF. 1MB max.',
      'social_profile' => 'Social Profiles',
    ],
    'preference' => [
      'theme' => 'Theme',
      'theme_dec' => 'Choose between light, dark and system theme.',
      'language_settings' => 'Language Settings',
      'language_settings_dec' => 'Set the default output language',
      'default_language' => 'Default Language',
    ],
    'usage' => [
      'total_usage' => 'Total Usage',
      'total_usage_dec' => 'Review your total usage across the platform since you registered.',
      'words_generated' => 'Words Generated',
      'document_generated' => 'Documents Generated',
      'language_settings_dec' => 'Set the default output language',
      'time_save' => 'Time Saved',
      'total_used' => 'Tool Used',
      'usage' => 'Usage',
    ],
    'billings' => [
      'subscriptions' => 'Subscription',
      'you_are_current_subscription' => 'You are currently on the',
      'not_subscribe' => ' You are not subscribed to any plan yet!',
      'cancel_subscription' => 'Are you sure?',
      'cancel_subscription_dec' => 'Are you sure you sure you want to cancel your current subscription plan? This is unreversible and your token and images limits will not be reverted.',
      'available_credit' => 'Available credits',
      'available_credit_dec' => 'View your credit balance and buy more credits.',
      'current_plan' => 'My Current Plan Status',
      'renew_date' => 'Renewal Date',
      'payment_history' => 'Payment History',
      'invoice' => 'Invoice',
    ],
    'all_integration' => [
      'all_integration' => 'All Integration',
      'all_integration_dec' => ' Connect and sync with essential tools and platforms.',
      'api_key' => 'API Key',
      'api_key_placeholder' => 'Input your Openai API key',
      'api_key_elevenlabs_placeholder' => 'Input your elevenlabs API key',
      'default_model' => 'Default Model',
      'image_model_label' => 'Image Model',
      'site_url' => 'Site URL',
      'username' => 'User name',
      'username_placeholder' => 'Your first name',
      'application_password' => 'Application password',
      'application_password_placeholder' => 'Input your wordpress application password.',
      'configure' => 'Configure',
    ],
    'translation' => [
      'select_default_language' => 'Select default language for application',
      'select_default_language_label' => 'Select a default language',
      'enable_disable_language' => 'Enable or disable language preset',
      'create_language_preset' => 'Create new language preset',
      'create_language_preset_label' => 'Select a language to translate',
      'add_new_language' => 'Add new language',
      'original_text' => 'Original text',
      'translation_text' => 'Translation',
    ],
  ];

  public function get_all_presets()
  {
    $language_presets = get_option($this->translation_key, []);
    if (empty($language_presets['english'])) {
      $language_presets['english'] = $this->get_english_language();
    }

    return $language_presets;
  }

  public function get_english_language()
  {
    return [
      'name' => 'English',
      'translation' => $this->default_string,
      'is_enable' => 'true',
      'iso_code' => "en_US",
      'icon' => UAI_ASSETS_URL . "/language/us.svg"
    ];
  }

  public function delete_language()
  {
    restrict_req_for_admin();

    if (!isset($_POST['language_name']) || empty($_POST['language_name'])) {
      wp_send_json(['res' => 'send proper data'], 400);
    }

    $language_name = sanitize_text_field($_POST['language_name']);
    $language_presets = $this->get_all_presets();

    if (empty($language_presets[$language_name])) {
      wp_send_json(['res' => 'language preset not available'], 400);
    }

    unset($language_presets[$language_name]);

    //save new presets
    update_option($this->translation_key, $language_presets);
    wp_send_json(['data' => "Removed preset successfully"], 200);
  }

  public function get_default_language()
  {
    $language_name = get_option($this->default_language_key, false);

    //TEMPORAY DISABLE THE FEATURED
    /* $user = (new Ultimate_AI_User_Manager())->get_full_user(wp_get_current_user());

    //get user preferred language if sets any
     if (!empty($user["meta"]["preferred_app_language"])) {
       $language_name = $user["meta"]["preferred_app_language"];
    } */

    return wp_unslash($this->get_translated_array($language_name));
  }

  public function save_default_language()
  {
    restrict_req_for_admin();
    if (!isset($_POST['language_name']) || empty($_POST['language_name'])) {
      wp_send_json(['res' => 'send proper data'], 400);
    }
    $language_name = sanitize_text_field($_POST['language_name']);
    $language_presets = $this->get_all_presets();

    if (empty($language_presets[$language_name])) {
      wp_send_json(['res' => 'language preset not available'], 400);
    }

    update_option($this->default_language_key, $language_name);
    wp_send_json(['data' => $language_name], 200);
  }

  public function get_translated_array($language_name = false)
  {
    $language_presets = $this->get_all_presets();
    if ($language_name == false || empty($language_presets[$language_name])) {
      return $this->default_string;
    }

    $filtered_blank_value = array_filter($language_presets[$language_name]['translation']);

    return array_replace_recursive($this->default_string, $filtered_blank_value);
  }

  public function array_remove_empty($haystack)
  {
    foreach ($haystack as $key => $value) {
      if (is_array($value)) {
        $haystack[$key] = $this->array_remove_empty($haystack[$key]);
      }

      if (empty($haystack[$key])) {
        unset($haystack[$key]);
      }
    }

    return $haystack;
  }

  public function save_translated_string()
  {
    restrict_req_for_admin();

    $required_field = ["translated_string", "language", "name", "iso_code", "icon"];
    foreach ($required_field as $field) {
      if (!isset($_POST[$field]) || empty($_POST[$field])) {
        wp_send_json(['res' => 'send proper data'], 400);
      }
    }

    $translated_string = wp_unslash(map_deep($_POST['translated_string'], 'sanitize_text_field'));
    $key = sanitize_key($_POST['language']);
    $name = sanitize_text_field($_POST['name']);
    $iso_code = sanitize_text_field($_POST['iso_code']);
    $icon_url = sanitize_url($_POST['icon']);
    $is_enable = sanitize_text_field($_POST['is_enable'] ?? 'true');

    // get default string
    $prev_val = $this->get_translated_array($key);
    // merge with translated one and filled default with blank keys
    $new_val = array_replace_recursive($prev_val, $this->array_remove_empty($translated_string));

    $language_presets = $this->get_all_presets();
    $_new_language = ['name' => $name, 'translation' => $new_val, 'is_enable' => $is_enable, 'iso_code' => $iso_code, 'icon' => $icon_url];
    $language_presets[$key] = $_new_language;

    update_option($this->translation_key, $language_presets);
    // temp, `key` will not going to save
    $_new_language['key'] = $key;

    wp_send_json(['status' => 'success', 'data' => $_new_language], 200);
  }

  public function get_translated_languages()
  {
    $language_name = get_option($this->default_language_key, '');
    if (empty($language_name)) {
      $language_name = $this->default_language;
    }

    wp_send_json([
      'data' => [
        'language_presets' => $this->get_all_presets(),
        'default_language_key' => $language_name,
      ],
    ], 200);
  }
}

new Ultimate_ai_Translation_Manager();

